program timerthread.dpr;
{$APPTYPE CONSOLE}

//
// This example demonstrates how to use the .NET timer to perform an 
// operation on another thread.
//
// Written by: Rick Ross (http://www.rick-ross.com/)
//

uses System.Threading;

type
  TMyTimerClass = class
  public
    procedure Alarm(state : System.Object);
  end;

procedure TMyTimerClass.Alarm(state : System.Object);
begin
  writeln(AppDomain.GetCurrentThreadID(),' Bzzzz. Time to wake up!');
  if assigned(state) then
    writeln('You passed me: ', state.ToString());
end;

var
  tc : TMyTimerclass;
  t  : Timer;

begin
  tc := TMyTimerClass.Create;
  t  := Timer.Create( @tc.Alarm, nil, 1000 , 0);
  writeln(AppDomain.GetCurrentThreadID(),' Waiting for the alarm... zzzzz');
  Thread.Sleep(2000);
  writeln(AppDomain.GetCurrentThreadID(),' Done!');
end.
